/** @file   BadAssAi.h
 * @brief   Declaration of BadAssAi class.
 * @version $Revision: 1.2 $
 * @date    $Date: 2006/07/13 16:25:33 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_BADASSAI_H
#define H_WWW_BADASSAI_H

#include "aicontroller.h"

namespace WeWantWar {

/** @class  BadAssAi
 * @brief   Contains the logic that controls the LightballAlien
 * @author  Tomi Lamminsaari
 *
 */
class BadAssAi : public AIController
{
public:

  ///
  /// Constants, datatypes and static methods
  /// =======================================

  ///
  /// Constructors, destructor and operators
  /// ======================================

  /** Default constructor.
   * @param   aObject           Pointer to GameObject whom we are controlling.
   */
  BadAssAi( GameObject* aObject );

  /** Destructor
   */
  ~BadAssAi();

private:
  BadAssAi( const BadAssAi& aAnother );
  BadAssAi& operator= ( const BadAssAi& aAnother );
public:

  ///
  /// Inherited methods
  /// =================

  /** Updates this controller.
   * @param   aSeeTarget        Tells if we can see our target.
   * @param   aDistance         Distance to our target.
   */
  virtual void updateAI( bool aSeeTarget, float aDistance );
  
  /** Sets the alerted mode on/off.
   * @param aAlerted            Alerted-flag status
   */
  void setAlerted(bool aAlerted);

protected:
  ///
  /// Data members
  /// ============

  /** Tells if we're in alerted mode. */
  bool      iAlerted;
  
  /** THe previous player position is stored here. */
  eng2d::Vec2D  iLastKnownPos;
};

};  // end of namespace

#endif
